<?php

declare(strict_types=1);

namespace JuicyCodes\Core;

use Carbon\Laravel\ServiceProvider;
use JuicyCodes\Core\Commands\CheckLicenseCommand;

class AppServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                CheckLicenseCommand::class,
            ]);
        }
    }

    public function register(): void
    {
        $this->app->singleton(Application::class);
    }
}
