<?php

declare(strict_types = 1);

namespace JuicyCodes\Core\Support\Facades;

use Illuminate\Support\Facades\Facade;
use JuicyCodes\Core\AppRepository;
use JuicyCodes\Core\License;
use JuicyCodes\Core\Support\Product;

/**
 * @method static Product app()
 * @method static License license()
 * @method static Product[] getPlugins()
 * @method static void verify(string $codename = null)
 * @method static void register(string $version, string $codename)
 * @method static void init(string $version, string $codename, string $license)
 */
class Application extends Facade
{
    protected static function getFacadeAccessor()
    {
        return AppRepository::class;
    }
}
