<?php

declare(strict_types=1);

namespace JuicyCodes\Core;

use JuicyCodes\Core\Support\Product;

class AppRepository
{
    protected Product $app;

    protected array $plugins;

    protected License $license;

    public function init(string $version, string $codename, string $license): void
    {
        $this->app     = $this->createProduct("main", $version, $codename);
        $this->license = new License($this, $license);
    }

    public function register(string $version, string $codename): void
    {
        $this->plugins[$codename] = $this->createProduct("child", $version, $codename);
    }

    public function verify(string $codename = null): void
    {
        $this->license()->verify($codename);
    }

    public function app(): Product
    {
        return $this->app;
    }

    public function getPlugins(): array
    {
        return $this->plugins;
    }

    public function license(): License
    {
        return $this->license;
    }

    protected function createProduct(string $type, string $version, string $codename): Product
    {
        $data = new Product();
        $data->setType($type);
        $data->setVersion($version);
        $data->setCodename($codename);

        return $data;
    }
}
