<?php

declare(strict_types = 1);

namespace JuicyCodes\Core\Support;

use Illuminate\Http\Response;

class InvalidResponse
{
    public static function htmlResponse(): void
    {
        echo self::template();
        exit;
    }

    public static function jsonResponse(array $reasons, bool $showReason = false): void
    {
        $response = [
            "message" => "Invalid License",
            "errors"  => [
                "license" => array_filter([
                    "There was a problem validating the app's license.",
                    $showReason ? $reasons[0] : null,
                    "Please check 'System Utilities' for more information.",
                ]),
            ],
        ];

        abort(response()->json($response, Response::HTTP_UNPROCESSABLE_ENTITY));
    }

    private static function template(): string
    {
        return <<< HTML
<!DOCTYPE html><html lang="en"><head> <meta charset="utf-8"> <title>Invalid License | JUICYCODES</title> <link rel="preconnect" href="https://fonts.gstatic.com"> <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/> <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;500;600&display=swap" rel="stylesheet"> <style>html{-webkit-text-size-adjust: 100%; line-height: 1.15; -moz-tab-size: 4; -o-tab-size: 4; tab-size: 4}body{font-family: system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, sans-serif, Apple Color Emoji, Segoe UI Emoji; margin: 0}html{font-family: Poppins, sans-serif; line-height: 1.5}body{font-family: inherit; line-height: inherit}*, :after, :before{border: 0 solid #e5e7eb; box-sizing: border-box}a{color: inherit; text-decoration: inherit}svg{display: block; vertical-align: middle}body{background-image: linear-gradient(135deg, #f5f7fa, rgba(195, 207, 226, .65))}.bg-white{--tw-bg-opacity: 1; background-color: rgba(255, 255, 255, var(--tw-bg-opacity))}.bg-gradient-to-r{background-image: linear-gradient(to right, var(--tw-gradient-stops))}.from-orange-400{--tw-gradient-from: #fb923c; --tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to, rgba(251, 146, 60, 0))}.to-red-500{--tw-gradient-to: #ef4444}.border-red-100{--tw-border-opacity: 1; border-color: rgba(254, 226, 226, var(--tw-border-opacity))}.border-t{border-top-width: 1px}.border-b{border-bottom-width: 1px}.flex{display: flex}.hidden{display: none}.flex-col{flex-direction: column}.justify-center{justify-content: center}.font-light{font-weight: 300}.font-medium{font-weight: 500}.font-semibold{font-weight: 600}.h-28{height: 7rem}.text-xs{font-size: .75rem; line-height: 1rem}.text-base{font-size: 1rem; line-height: 1.5rem}.text-3xl{font-size: 1.875rem; line-height: 2.25rem}.mx-auto{margin-left: auto; margin-right: auto}.max-w-lg{max-width: 32rem}.min-h-screen{min-height: 100vh}.overflow-hidden{overflow: hidden}.py-3{padding-bottom: .75rem; padding-top: .75rem}.px-4{padding-left: 1rem; padding-right: 1rem}.py-6{padding-bottom: 1.5rem; padding-top: 1.5rem}.py-10{padding-bottom: 2.5rem; padding-top: 2.5rem}.pt-4{padding-top: 1rem}.pb-4{padding-bottom: 1rem}.absolute{position: absolute}.relative{position: relative}.inset-0{bottom: 0; left: 0; right: 0; top: 0}.-top-6{top: -1.5rem}.-right-8{right: -2rem}*{--tw-shadow: 0 0 #0000}.shadow-lg{--tw-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05); box-shadow: var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow)}*{--tw-ring-inset: var(--tw-empty, /*!*/ /*!*/); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(59, 130, 246, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000}.fill-current{fill: currentColor}.text-center{text-align: center}.text-gray-500{--tw-text-opacity: 1; color: rgba(107, 114, 128, var(--tw-text-opacity))}.text-red-400{--tw-text-opacity: 1; color: rgba(248, 113, 113, var(--tw-text-opacity))}.text-red-500{--tw-text-opacity: 1; color: rgba(239, 68, 68, var(--tw-text-opacity))}.text-orange-700{--tw-text-opacity: 1; color: rgba(194, 65, 12, var(--tw-text-opacity))}.hover\:text-orange-600:hover{--tw-text-opacity: 1; color: rgba(234, 88, 12, var(--tw-text-opacity))}.uppercase{text-transform: uppercase}.w-28{width: 7rem}.transform{--tw-translate-x: 0; --tw-translate-y: 0; --tw-rotate: 0; --tw-skew-x: 0; --tw-skew-y: 0; --tw-scale-x: 1; --tw-scale-y: 1; transform: translateX(var(--tw-translate-x)) translateY(var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.-skew-y-6{--tw-skew-y: -6deg}@media (min-width: 640px){.sm\:rounded-xl{border-radius: .75rem}.sm\:block{display: block}.sm\:text-4xl{font-size: 2.25rem; line-height: 2.5rem}.sm\:mx-auto{margin-left: auto; margin-right: auto}.sm\:max-w-2xl{max-width: 42rem}.sm\:py-12{padding-bottom: 3rem; padding-top: 3rem}.sm\:px-14{padding-left: 3.5rem; padding-right: 3.5rem}.sm\:-rotate-6{--tw-rotate: -6deg}.sm\:skew-y-0{--tw-skew-y: 0deg}}</style></head><body> <div class="min-h-screen py-6 flex flex-col justify-center sm:py-12"> <div class="relative py-3 sm:max-w-2xl sm:mx-auto"> <div class="absolute inset-0 bg-gradient-to-r from-orange-400 to-red-500 shadow-lg transform -skew-y-6 sm:skew-y-0 sm:-rotate-6 sm:rounded-xl"></div><div class="relative px-4 py-10 bg-white shadow-lg sm:rounded-xl sm:px-14 overflow-hidden"> <div class="max-w-lg mx-auto"> <div class="pb-4"> <div class="font-semibold text-red-500 text-3xl text-center sm:text-4xl uppercase"> <a href="https://juicy.codes" target="_blank"> <img src="data:image/png;base64,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" alt="JUICYCODES" class="mx-auto"/> </a> </div><div class="absolute -right-8 -top-6"> <svg class="hidden w-28 h-28 fill-current text-red-400 sm:block" stroke="#FECACA" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"> <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path> </svg> </div></div><div class="border-t border-b border-red-100 py-6"> <div class="text-base text-center font-medium text-red-500">There was a problem validating the license.</div><div class="text-base text-center font-light text-gray-500 pt-4">Sign in to dashboard for more information.</div></div><div class="pt-4 font-medium text-xs text-gray-500 text-center"> <span>DEVELOPED WITH <span class="text-red-500">❤</span> BY</span> <a href="https://juicy.codes" class="text-orange-700 hover:text-orange-600">JUICY CODES</a> </div></div></div></div></div></body></html>
HTML;
    }
}
