<?php

declare(strict_types = 1);

namespace JuicyCodes\Core;

use JuicyCodes\Core\Support\MockLicense;

class Product
{
    protected string $type;

    protected string $version;

    protected string $codename;

    protected License $license;

    public function license(): License
    {
        return $this->license
            ??= $this->createLicenseInstance();
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): void
    {
        $this->type = $type;
    }

    public function getVersion(): string
    {
        return $this->version;
    }

    public function setVersion(string $version): void
    {
        $this->version = $version;
    }

    public function getCodename(): string
    {
        return $this->codename;
    }

    public function setCodename(string $codename): void
    {
        $this->codename = $codename;
    }

    protected function createLicenseInstance(): License
    {
        return !App::mockLicense()
            ? new License($this)
            : new MockLicense($this);
    }
}
