<?php

declare(strict_types=1);

use Symfony\Component\Finder\Finder;
use Symfony\Component\Finder\SplFileInfo;

test('No debugging statements are left in the code.')
    ->expect(['dd', 'dump', 'ray'])
    ->not->toBeUsed();

test(
    '`App` namespace is not used',
    function (SplFileInfo $file) {
        expect($file->getContents())->not->toContain('App');
    }
)->with(fn () => phpFiles());

function phpFiles(): array
{
    $files = Finder::create()
        ->in([__DIR__.'/../src', __DIR__.'/../database'])
        ->name('*.php')
        ->files();

    return collect($files)
        ->mapWithKeys(fn ($file) => [$file->getRelativePathname() => [$file]])
        ->toArray();
}
