<?php

declare(strict_types=1);

namespace Bridge\Support\Pagination;

use Attribute;
use Bridge\Support\Pagination\Data\PaginatedRecordsData;
use phpDocumentor\Reflection\Type;
use Spatie\TypeScriptTransformer\Attributes\TypeScriptTransformableAttribute;
use Spatie\TypeScriptTransformer\Types\TypeScriptType;

if (!interface_exists(TypeScriptTransformableAttribute::class)) {
    return;
}

#[Attribute]
readonly class PaginatedRecordsType implements TypeScriptTransformableAttribute
{
    public function __construct(
        private string $type,
    ) {}

    public function getType(): Type
    {
        $genericType = str_replace('\\', '.', $this->type);
        $baseType = str_replace('\\', '.', PaginatedRecordsData::class);

        return new TypeScriptType("{$baseType}<{$genericType}>");
    }
}
