<?php

declare(strict_types=1);

namespace Bridge\Support\Pagination\Data;

use Bridge\Support\Data\Data;
use Bridge\Support\Pagination\DataWithPaginator;
use Spatie\TypeScriptTransformer\Attributes\LiteralTypeScriptType;
use Spatie\TypeScriptTransformer\Attributes\TypeScript;

/**
 * @template TData of DataWithPaginator
 */
#[TypeScript('PaginatedRecordsData<TData>')]
class PaginatedRecordsData extends Data
{
    /**
     * @var array<TData>
     */
    #[LiteralTypeScriptType('TData[]')]
    public array $data;

    public PaginationData $pagination;

    public PaginationMetaData $meta;
}
