<?php

declare(strict_types=1);

namespace Bridge\Support;

use Illuminate\Support\Arr;
use Squire\Models\Country as SquireCountry;
use Squire\Repository;

/**
 * @property-read string $code_2
 * @property-read string $name
 */
class Country
{
    /**
     * @return string[]
     */
    public static function codes(): array
    {
        dd(Repository::getSources(), SquireCountry::all()->toArray());

        return array_keys(static::options());
    }

    /**
     * @return array<string, string>
     */
    public static function options(): array
    {
        $countries = SquireCountry::query()
            ->orderBy('name')
            ->get();

        return Arr::mapWithKeys($countries->all(), function (SquireCountry $country) {
            // @phpstan-ignore-next-line
            return [$country->code_2 => $country->name];
        });
    }
}
