<?php

declare(strict_types=1);

namespace Bridge\Support\Actions;

use Illuminate\Database\Eloquent\Builder;
use Lorisleiva\Actions\ActionRequest;

abstract class DeleteRecordsAction extends AbstractAction
{
    public function performAction(Builder $query, ActionRequest $request): void
    {
        $count = $query->delete();

        if ($count === 0) {
            toast()->error(__('No records were deleted.'));
        }

        if (method_exists($this, 'afterDelete')) {
            $this->afterDelete($request);
        }
    }
}
