<?php

declare(strict_types=1);

namespace Bridge;

use Bridge\Domains\Invoice\Enums\InvoiceContactType;
use Bridge\Domains\Member\Customer;
use Bridge\Domains\Supplier\Supplier;
use Bridge\Support\MaskedId\MaskedId;
use Bridge\Support\Toast\Toast;
use Carbon\CarbonImmutable;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\ServiceProvider;
use Jenssegers\Optimus\Optimus;
use Spatie\Activitylog\Facades\CauserResolver;

class PackageServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        Relation::morphMap([
            InvoiceContactType::Supplier->value => Supplier::class,
            InvoiceContactType::Customer->value => Customer::class,
        ]);

        Date::use(CarbonImmutable::class);
        config()->set('data.date_format', [
            'Y-m-d',
            'Y-m-d H:i:s',
            // ISO 8601, laravel model toArray() uses this format
            'Y-m-d\TH:i:s.uT',
            config('data.date_format'),
        ]);

        $this->loadMigrationsFrom(__DIR__.'/../database/migrations');

        if (Auth::check()) {
            CauserResolver::setCauser(Auth::user());
        }
    }

    public function register(): void
    {
        $this->app->singleton(Toast::class, fn () => new Toast());
        $this->app->singleton(MaskedId::class, fn () => new MaskedId(
            optimus: new Optimus(
                (int) config('services.optimus.prime'),
                (int) config('services.optimus.inverse'),
                (int) config('services.optimus.random'),
                size: 31
            )
        ));
    }
}
