<?php

declare(strict_types=1);

namespace Bridge\Domains\Ticket\Support;

use Bridge\Domains\Ticket\Models\Ticket;
use Bridge\Support\SequentialCodeGenerator;

trait HasTicketNumber
{
    public static function bootHasTicketNumber(): void
    {
        static::creating(function (Ticket $model) {
            $model->number = $model->generateNumber();
        });
    }

    public function generateNumber(): string
    {
        return SequentialCodeGenerator::generate($this->withTrashed(), ['ST']);
    }
}
