<?php

declare(strict_types=1);

namespace Bridge\Domains\Ticket\Data;

use Bridge\Domains\Member\Enums\MemberType;
use Bridge\Domains\Ticket\Enums\TicketCreator;
use Bridge\Domains\Ticket\Enums\TicketStatus;
use Bridge\Domains\Ticket\Models\Ticket;
use Bridge\Support\Pagination\DataWithPaginator;

/**
 * @extends DataWithPaginator<TicketData>
 */
class TicketData extends DataWithPaginator
{
    public function __construct(
        readonly public string $number,

        readonly public string $subject,

        readonly public TicketStatus $status,

        readonly public MemberType $lastReplyFrom,

        readonly public string $timeDifference,

        readonly public bool $selfAuthored,
    ) {}

    public static function fromModel(Ticket $record): self
    {
        return self::from([
            ...$record->getRelations(),
            ...$record->withoutRelations()->toArray(),
            'selfAuthored' => $record->created_by === TicketCreator::Customer,
            'timeDifference' => $record->created_at?->diffForHumans(short: true) ?? '',
        ]);
    }
}
