<?php

declare(strict_types=1);

namespace Bridge\Domains\Supplier;

use Bridge\Database\Factories\SupplierFactory;
use Bridge\Support\ModelTraits;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Supplier extends Model
{
    use HasFactory;
    use ModelTraits;
    use SoftDeletes;

    /**
     * @return Attribute<string,never>
     */
    protected function moniker(): Attribute
    {
        return Attribute::get(fn () => $this->nickname ?? $this->name);
    }

    /**
     * @return Factory<Supplier>
     */
    protected static function newFactory(): Factory
    {
        return SupplierFactory::new();
    }
}
