<?php

declare(strict_types=1);

namespace Bridge\Domains\Member;

use Bridge\Database\Factories\MemberFactory;
use Bridge\Domains\Member\Enums\MemberType;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\Factory;

class Customer extends Member
{
    protected static function booted(): void
    {
        static::addGlobalScope('type', function (Builder $builder) {
            $builder->where('type', MemberType::Customer);
        });

        static::creating(function (self $model) {
            $model->type = MemberType::Customer;
        });
    }

    protected static function newFactory(): Factory
    {
        return MemberFactory::new()->customer();
    }
}
