<?php

declare(strict_types=1);

namespace Bridge\Domains\Invoice\Support\Traits;

use Bridge\Domains\Invoice\Models\Invoice;
use Bridge\Support\Casts\Amount;
use Illuminate\Support\Facades\DB;

trait InvoiceCommonCalculations
{
    public function calculateRemainingInUsd(?Invoice $invoice = null): float
    {
        $invoice ??= $this;

        $totalInUsd = $invoice->total / $invoice->currency_rate;
        $alreadyPaidInUsd = $invoice->payments()->sum(DB::raw('amount / currency_rate'));

        return Amount::bigDecimal($totalInUsd)
            ->minus(Amount::bigDecimal($alreadyPaidInUsd))
            ->toFloat();
    }

    public function discountAmount(): float
    {
        $discountInUsd = $this->items()->sum(DB::raw('discount / currency_rate'));

        return $discountInUsd / $this->currency_rate;
    }
}
