<?php

declare(strict_types=1);

namespace Bridge\Domains\Invoice\Support\Traits;

use Bridge\Domains\Invoice\Enums\InvoiceType;
use Bridge\Domains\Invoice\Models\Invoice;
use Bridge\Support\SequentialCodeGenerator;
use Carbon\CarbonImmutable;
use Illuminate\Support\Str;

trait GenerateInvoiceNumber
{
    public static function bootGenerateInvoiceNumber(): void
    {
        static::creating(function (Invoice $model) {
            if (empty($model->number)) {
                $model->number = $model->generateNumber($model->type, $model->issued_on->toImmutable());
            }
        });
    }

    public function generateNumber(InvoiceType $type, CarbonImmutable $issuedOn): string
    {
        $typePrefix = $type->value[0];
        if (str_contains($type->value, '-')) {
            $typePrefix .= Str::after($type->value, '-')[0];
        }

        return SequentialCodeGenerator::generate($this->withTrashed(), [$typePrefix], $issuedOn);
    }
}
