<?php

declare(strict_types=1);

namespace Bridge\Domains\Invoice\Models;

use Bridge\Database\Factories\InvoiceItemFactory;
use Bridge\Domains\Currency\Currency;
use Bridge\Domains\Item\Models\Item;
use Bridge\Support\ModelTraits;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @property-read Item $item
 * @property-read Currency $currency
 */
class InvoiceItem extends Model
{
    use HasFactory;
    use ModelTraits;
    use SoftDeletes;

    protected $casts = [
        'price' => 'float',
        'quantity' => 'integer',
        'currency_rate' => 'float',
    ];

    /**
     * @return BelongsTo<Invoice,InvoiceItem>
     */
    public function invoice(): BelongsTo
    {
        return $this->belongsTo(Invoice::class);
    }

    /**
     * @return BelongsTo<Item,InvoiceItem>
     */
    public function item(): BelongsTo
    {
        return $this->belongsTo(Item::class);
    }

    /**
     * @return BelongsTo<Currency,InvoiceItem>
     */
    public function currency(): BelongsTo
    {
        return $this->belongsTo(Currency::class);
    }

    /**
     * @return Factory<InvoiceItem>
     */
    protected static function newFactory(): Factory
    {
        return InvoiceItemFactory::new();
    }
}
