<?php

declare(strict_types=1);

namespace Bridge\Domains\Discount\Models;

use Bridge\Database\Factories\DiscountItemFactory;
use Bridge\Domains\Discount\Enums\DiscountType;
use Bridge\Domains\Item\Models\Item;
use Bridge\Support\Casts\Amount;
use Bridge\Support\ModelTraits;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property-read Item $item
 */
class DiscountItem extends Model
{
    use HasFactory;
    use ModelTraits;

    protected $casts = [
        'amount' => Amount::class,
        'type' => DiscountType::class,
    ];

    /**
     * @return BelongsTo<Item,DiscountItem>
     */
    public function item(): BelongsTo
    {
        return $this->belongsTo(Item::class);
    }

    /**
     * @return Factory<DiscountItem>
     */
    protected static function newFactory(): Factory
    {
        return DiscountItemFactory::new();
    }
}
