<?php

declare(strict_types=1);

namespace Bridge\Domains\Discount\Models;

use Bridge\Database\Factories\DiscountFactory;
use Bridge\Domains\Discount\Enums\DiscountCustomerType;
use Bridge\Domains\Discount\Enums\DiscountStatus;
use Bridge\Support\ModelTraits;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Discount extends Model
{
    use HasFactory;
    use ModelTraits;
    use SoftDeletes;

    protected $casts = [
        'status' => DiscountStatus::class,
        'customer_type' => DiscountCustomerType::class,
    ];

    /**
     * @return HasMany<DiscountItem>
     */
    public function items(): HasMany
    {
        return $this->hasMany(DiscountItem::class);
    }

    /**
     * @param  Builder<Discount>  $query
     * @return Builder<Discount>
     */
    public function scopeActive(Builder $query): Builder
    {
        return $query->where('status', DiscountStatus::Active);
    }

    /**
     * @return Factory<Discount>
     */
    protected static function newFactory(): Factory
    {
        return DiscountFactory::new();
    }
}
