<?php

declare(strict_types=1);

namespace Bridge\Domains\Currency;

use Bridge\Database\Factories\CurrencyFactory;
use Bridge\Domains\Account\Account;
use Bridge\Support\Casts\Rate;
use Bridge\Support\ModelTraits;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Currency extends Model
{
    use HasFactory;
    use ModelTraits;
    use SoftDeletes;

    protected $casts = [
        'rate' => Rate::class,
    ];

    /**
     * @return HasMany<Account>
     */
    public function accounts(): HasMany
    {
        return $this->hasMany(Account::class);
    }

    public function isDefault(): bool
    {
        return $this->code === 'USD';
    }

    public static function defaultCurrency(): self
    {
        return self::query()->where('code', 'USD')->sole();
    }

    /**
     * @return Factory<Currency>
     */
    protected static function newFactory(): Factory
    {
        return CurrencyFactory::new();
    }
}
