<?php

declare(strict_types=1);

namespace Bridge\Database\Seeders;

use Bridge\Domains\Member\Customer;
use Bridge\Domains\Member\Staff;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        if (app()->isProduction()) {
            return;
        }

        Staff::factory()->create([
            'name' => 'Admin',
            'email' => 'dev@tontri.com',
        ]);

        Customer::factory()->create([
            'name' => 'Tridip',
            'email' => 'tridip@tontri.com',
        ]);

        if (!app()->runningUnitTests()) {
            Staff::factory()->count(2)->create();
            Customer::factory()->count(3)->create();
        }
    }
}
