<?php

declare(strict_types=1);

use Bridge\Domains\Member\Member;
use Bridge\Domains\Ticket\Models\Ticket;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ticket_replies', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Ticket::class)
                ->constrained()
                ->restrictOnDelete();

            $table->foreignId('author_id')
                ->constrained(Member::table())
                ->restrictOnDelete();

            $table->text('body');
            $table->unsignedTinyInteger('order')->default(0);

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ticket_replies');
    }
};
