<?php

declare(strict_types=1);

use Bridge\Domains\Bookkeeping\Enums\CompanyShareholder;
use Bridge\Domains\Bookkeeping\FiscalReport;
use Bridge\Domains\Currency\Currency;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('fiscal_transactions', function (Blueprint $table) {
            $table->id();

            $table->date('paid_on')->index();
            $table->enum('paid_by', CompanyShareholder::options());
            $table->decimal('amount', 10);
            $table->string('paid_via', 100);
            $table->text('notes')->nullable();

            $table->foreignIdFor(Currency::class)
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->decimal('currency_rate', 10, 4);

            $table->foreignIdFor(FiscalReport::class)
                ->nullable()
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('fiscal_transactions');
    }
};
