<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('fiscal_reports', function (Blueprint $table) {
            $table->id();
            $table->date('month')->unique();

            $table->decimal('profit', 7)
                ->virtualAs('revenue - expense');

            $table->decimal('revenue', 7);
            $table->decimal('expense', 7);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('fiscal_reports');
    }
};
