<?php

declare(strict_types=1);

use Bridge\Domains\Discount\Enums\DiscountType;
use Bridge\Domains\Discount\Models\Discount;
use Bridge\Domains\Item\Models\Item;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('discount_items', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Discount::class)
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->foreignIdFor(Item::class)
                ->constrained()
                ->restrictOnUpdate()
                ->restrictOnDelete();

            $table->enum('type', DiscountType::options());
            $table->decimal('amount', 10)->default(0);

            $table->timestamps();
            $table->unique(['discount_id', 'item_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('discount_items');
    }
};
