<?php

declare(strict_types=1);

namespace Bridge\Database\Factories;

use Bridge\Domains\Member\Member;
use Bridge\Domains\Ticket\Models\Ticket;
use Bridge\Domains\Ticket\Models\TicketReply;
use Closure;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<TicketReply>
 */
class TicketReplyFactory extends Factory
{
    protected $model = TicketReply::class;

    /**
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'ticket_id' => Ticket::factory(),
            'author_id' => $this->getAuthorId(),
            'body' => $this->faker->paragraphs(rand(1, 5), asText: true),
        ];
    }

    private function getAuthorId(): Closure
    {
        return function (array $attributes): int {
            /** @var Ticket $ticket */
            $ticket = Ticket::query()->findOrFail($attributes['ticket_id']);

            return fake()->boolean
                ? $ticket->customer_id
                : $ticket->assigned_to ?? Member::query()->isStaff()->inRandomOrder()->value('id');
        };
    }
}
