<?php

declare(strict_types=1);

namespace Bridge\Database\Factories;

use Bridge\Domains\Item\Models\Item;
use Bridge\Domains\Item\Models\ItemMeta;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<ItemMeta>
 */
class ItemMetaFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var class-string<ItemMeta>
     */
    protected $model = ItemMeta::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'item_id' => Item::factory(),
            'key' => Str::ulid()->toBase32(),
            'value' => Str::random(),
        ];
    }
}
