<?php

declare(strict_types=1);

namespace Bridge\Database\Factories;

use Bridge\Domains\Discount\Enums\DiscountCustomerType;
use Bridge\Domains\Discount\Enums\DiscountStatus;
use Bridge\Domains\Discount\Models\Discount;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends Factory<Discount>
 */
class DiscountFactory extends Factory
{
    protected $model = Discount::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->sentence(3),
            'code' => strtoupper(Str::random(10)),
            'status' => $this->faker->randomElement(DiscountStatus::options()),
            'customer_type' => $this->faker->randomElement(DiscountCustomerType::options()),
        ];
    }
}
