<?php

declare(strict_types=1);

namespace Bridge\Support\Toast;

use Bridge\Support\Toast\Enums\ToastType;

class Toast
{
    public function info(string $message): void
    {
        $this->send(ToastType::Info, $message);
    }

    public function error(string $message): void
    {
        $this->send(ToastType::Error, $message);
    }

    public function success(string $message): void
    {
        $this->send(ToastType::Success, $message);
    }

    public function warning(string $message): void
    {
        $this->send(ToastType::Warning, $message);
    }

    public function send(ToastType $type, string $message): void
    {
        $toast = ToastData::from(compact('type', 'message'));

        session()->flash('toast', $toast->toArray());
    }
}
