<?php

declare(strict_types=1);

namespace Bridge\Support\MaskedId;

use Illuminate\Foundation\Http\Middleware\TransformsRequest;

class MaskedIdTransformer extends TransformsRequest
{
    protected function transform($key, $value)
    {
        if (MaskedId::canBeDecoded($value, $key)) {
            return app(MaskedId::class)->decodeModelId($value);
        }

        return $value;
    }
}
