<?php

declare(strict_types=1);

namespace Bridge\Support\MaskedId;

use Illuminate\Database\Eloquent\Model;
use Spatie\LaravelData\Casts\Cast;
use Spatie\LaravelData\Support\Creation\CreationContext;
use Spatie\LaravelData\Support\DataProperty;

class MaskedIdCast implements Cast
{
    /**
     * @var class-string<Model>
     */
    protected string $model;

    /**
     * @param  class-string<Model>|null  $model
     */
    public function __construct(?string $model = null)
    {
        $this->model = $model ?? Model::class;
    }

    // @phpstan-ignore-next-line
    public function cast(DataProperty $property, mixed $value, array $properties, CreationContext $context): mixed
    {
        return match ($this->needsToEncode()) {
            true => app(MaskedId::class)->encodeModelId($this->model, (int) $value),
            false => $value,
        };
    }

    private function needsToEncode(): bool
    {
        return request()->isMethod('GET')
            && !app()->runningInConsole();
    }
}
