<?php

declare(strict_types=1);

namespace Bridge\Support\Data\Transformers;

use Carbon\CarbonImmutable;
use Spatie\LaravelData\Support\DataProperty;
use Spatie\LaravelData\Support\Transformation\TransformationContext;
use Spatie\LaravelData\Transformers\Transformer;

class DateDistanceInDay implements Transformer
{
    public function transform(DataProperty $property, mixed $value, TransformationContext $context): string
    {
        assert($value instanceof CarbonImmutable);

        $value = $value->startOfDay();
        $diff = $value->diffForHumans(now()->startOfDay(), [
            'minimumUnit' => 'd',
        ]);

        return match (true) {
            default => $diff,
            $value->isToday() => 'today',
            $value->isTomorrow() => 'tomorrow',
            $value->isYesterday() => 'yesterday',
            $value->isPast() => str_replace('before', 'ago', $diff),
            $value->isFuture() => 'in '.str_replace(' after', '', $diff),
        };
    }
}
