<?php

declare(strict_types=1);

namespace Bridge\Support\Data\Transformers;

use Spatie\LaravelData\Support\DataProperty;
use Spatie\LaravelData\Support\Transformation\TransformationContext;
use Spatie\LaravelData\Transformers\Transformer;
use Squire\Models\Country;

class CountryTransformer implements Transformer
{
    public function transform(DataProperty $property, mixed $value, TransformationContext $context): string
    {
        return Country::find($value)->name ?? $value;
    }
}
