<?php

declare(strict_types=1);

namespace Bridge\Support\Actions\Traits;

use Illuminate\Database\Eloquent\Model;

trait ActionHasRecord
{
    private Model $record;

    public function record(): Model
    {
        if (isset($this->record)) {
            return $this->record;
        }

        /** @var Model $record */
        $record = request()->route('record');

        return $this->record = $record;
    }
}
