<?php

declare(strict_types=1);

namespace Bridge\Support\Actions;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\DB;
use Lorisleiva\Actions\ActionRequest;

abstract class DeleteRecordsAction extends AbstractAction
{
    public function performAction(Builder $query, ActionRequest $request): void
    {
        DB::transaction(function () use ($query, $request) {
            $count = $query->delete();

            if ($count === 0) {
                toast()->error(__('No records were deleted.'));
            }

            if (method_exists($this, 'afterDelete')) {
                $this->afterDelete($request);
            }
        });
    }
}
