<?php

declare(strict_types=1);

namespace Bridge\Support\Actions;

use BackedEnum;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\Rules\Enum;
use Lorisleiva\Actions\ActionRequest;

/**
 * @template TEnum of BackedEnum
 */
abstract class ChangeStatusActions extends AbstractAction
{
    /**
     * @return class-string<TEnum>
     */
    abstract protected function statusEnum(): string;

    public function rules(): array
    {
        return array_merge(parent::rules(), [
            'status' => ['required', 'string', new Enum($this->statusEnum())],
        ]);
    }

    public function performAction(Builder $query, ActionRequest $request): void
    {
        DB::transaction(function () use ($query, $request) {
            $enum = $this->statusEnum();

            $count = $query->update([
                'status' => $enum::from($request->input('status')),
            ]);

            if ($count === 0) {
                toast()->error(__('No records were updated.'));
            }

            $this->afterUpdate($query, $request);
        });
    }

    /**
     * @param  Builder<Model>  $query
     */
    protected function afterUpdate(Builder $query, ActionRequest $request): void
    {
        //
    }
}
