<?php

declare(strict_types=1);

namespace Bridge\Domains\Server\Models;

use Bridge\Database\Factories\ServerFactory;
use Bridge\Domains\Item\Models\Item;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Relations\HasOne;

/**
 * @property-read ItemServerDetails $details
 */
class Server extends Item
{
    /**
     * @return HasOne<ItemServerDetails>
     */
    public function details(): HasOne
    {
        return $this->hasOne(ItemServerDetails::class, 'item_id');
    }

    /**
     * @param  Builder<static>  $query
     * @return Builder<static>
     */
    public function scopeWithViewRelations(Builder $query): Builder
    {
        return $query->with(['details', 'details.customer', 'supplier', 'price', 'price.buyCurrency', 'price.sellCurrency']);
    }

    public function loadFormRelations(): static
    {
        return parent::loadFormRelations()->load('details');
    }

    public function loadViewRelations(): static
    {
        return parent::loadViewRelations()->load('details', 'details.customer');
    }

    /**
     * @return Factory<Server>
     */
    protected static function newFactory(): Factory
    {
        return ServerFactory::new();
    }
}
