<?php

declare(strict_types=1);

namespace Bridge\Domains\Member;

use Bridge\Database\Factories\MemberFactory;
use Bridge\Domains\Member\Enums\MemberType;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\Factory;

class Staff extends Member
{
    protected static function booted(): void
    {
        static::addGlobalScope('type', function (Builder $builder) {
            $builder->where('type', MemberType::Staff);
        });

        static::creating(function (Member $member) {
            $member->type = MemberType::Staff;
        });
    }

    protected static function newFactory(): Factory
    {
        return MemberFactory::new()->staff();
    }
}
