<?php

declare(strict_types=1);

namespace Bridge\Domains\License\Models;

use Bridge\Domains\Product\ProductType;
use Bridge\Domains\ProductVersion\ProductVersion;
use Bridge\Support\ModelTraits;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property int $erp_product_id
 * @property string $name
 * @property ProductType $type
 */
class Product extends Model
{
    use ModelTraits;

    protected $connection = 'license_mysql';

    protected $casts = [
        'type' => ProductType::class,
    ];

    /**
     * @return HasMany<ProductVersion>
     */
    public function versions(): HasMany
    {
        return $this->hasMany(ProductVersion::class);
    }

    /**
     * @param  Builder<Product>  $query
     * @return Builder<Product>
     */
    public function scopeIsCore(Builder $query): Builder
    {
        return $query->where('type', ProductType::Core);
    }
}
