<?php

declare(strict_types=1);

namespace Bridge\Domains\Item\Models;

use Bridge\Database\Factories\ItemMetaFactory;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ItemMeta extends Model
{
    use HasFactory;

    /**
     * @return BelongsTo<Item,ItemMeta>
     */
    public function item(): BelongsTo
    {
        return $this->belongsTo(Item::class, 'item_id');
    }

    /**
     * @return Factory<ItemMeta>
     */
    protected static function newFactory(): Factory
    {
        return ItemMetaFactory::new();
    }
}
