<?php

declare(strict_types=1);

namespace Bridge\Domains\Item\Enums;

use ArchTech\Enums\Options;
use ArchTech\Enums\Values;
use Bridge\Domains\Item\Models\Item;
use Bridge\Domains\Product\Product;
use Bridge\Domains\Server\Models\Server;
use Bridge\Domains\Service\Service;
use Spatie\TypeScriptTransformer\Attributes\TypeScript;

#[TypeScript]
enum ItemType: string
{
    use Options;
    use Values;

    case Server = 'server';
    case Product = 'product';
    case Service = 'service';

    public function isServer(): bool
    {
        return $this === self::Server;
    }

    /**
     * @return class-string<Item>
     */
    public function model(): string
    {
        return match ($this) {
            self::Server => Server::class,
            self::Product => Product::class,
            self::Service => Service::class,
        };
    }

    public static function fromModel(string $class): self
    {
        $type = str($class)->afterLast('\\')->lower();

        return self::from((string) $type);
    }
}
