<?php

declare(strict_types=1);

namespace Bridge\Domains\Invoice\Tasks;

use Bridge\Domains\Invoice\Enums\InvoiceStatus;
use Bridge\Domains\Invoice\Models\Invoice;

class MarkInvoiceAsCancelled extends AbstractTask
{
    protected static function handle(Invoice $invoice): void
    {
        // Mark the invoice as cancelled
        $invoice->status = InvoiceStatus::Cancelled;
        $invoice->save();

        // Clear any payment associated with this invoice
        self::cleanupPayments($invoice);

        // Clear all licenses associated with this invoice
        self::cleanupItemLicenses($invoice);

        // Clear all item ownership associated with this invoice
        self::cleanupItemOwnership($invoice);
    }
}
