<?php

declare(strict_types=1);

namespace Bridge\Domains\Invoice\Support\Traits;

use Bridge\Domains\Invoice\Models\InvoicePayment;
use Bridge\Support\SequentialCodeGenerator;
use Carbon\CarbonImmutable;

trait GeneratePaymentNumber
{
    public static function bootGeneratePaymentNumber(): void
    {
        static::creating(function (InvoicePayment $model) {
            if (empty($model->number)) {
                $model->number = $model->generateNumber($model->paid_on->toImmutable());
            }
        });
    }

    public function generateNumber(CarbonImmutable $paidOn): string
    {
        return SequentialCodeGenerator::generate($this->withTrashed(), [
            'T', // To indicate that this is a payment
        ], $paidOn);
    }
}
