<?php

declare(strict_types=1);

namespace Bridge\Domains\Invoice\Models;

use Bridge\Database\Factories\InvoiceScheduleFactory;
use Bridge\Domains\Invoice\Enums\RecurringEndType;
use Bridge\Domains\Invoice\Enums\RecurringFrequency;
use Bridge\Support\ModelTraits;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class InvoiceSchedule extends Model
{
    use HasFactory;
    use ModelTraits;
    use SoftDeletes;

    protected $casts = [
        'due_on' => 'integer',
        'interval' => 'integer',
        'end_after' => 'integer',
        'end_on' => 'date:Y-m-d',
        'start_on' => 'date:Y-m-d',
        'end_type' => RecurringEndType::class,
        'frequency' => RecurringFrequency::class,
    ];

    /**
     * @return BelongsTo<Invoice,InvoiceSchedule>
     */
    public function invoice(): BelongsTo
    {
        return $this->belongsTo(Invoice::class);
    }

    /**
     * @return Factory<InvoiceSchedule>
     */
    protected static function newFactory(): Factory
    {
        return InvoiceScheduleFactory::new();
    }
}
