<?php

declare(strict_types=1);

namespace Bridge\Domains\Invoice\Models;

use Bridge\Domains\Account\Account;
use Bridge\Domains\Currency\Currency;
use Bridge\Domains\Invoice\Support\Traits\GeneratePaymentNumber;
use Bridge\Support\Casts\Amount;
use Bridge\Support\Casts\Rate;
use Bridge\Support\ModelTraits;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @property-read Account $account
 * @property-read Currency $currency
 */
class InvoicePayment extends Model
{
    use GeneratePaymentNumber;
    use HasFactory;
    use ModelTraits;
    use SoftDeletes;

    protected $casts = [
        'paid_on' => 'date:Y-m-d',
        'amount' => Amount::class,
        'currency_rate' => Rate::class,
    ];

    /**
     * @return BelongsTo<Invoice,InvoicePayment>
     */
    public function invoice(): BelongsTo
    {
        return $this->belongsTo(Invoice::class);
    }

    /**
     * @return BelongsTo<Account,InvoicePayment>
     */
    public function account(): BelongsTo
    {
        return $this->belongsTo(Account::class);
    }

    /**
     * @return BelongsTo<Currency,InvoicePayment>
     */
    public function currency(): BelongsTo
    {
        return $this->belongsTo(Currency::class);
    }
}
