<?php

declare(strict_types=1);

namespace Bridge\Domains\Invoice\Enums;

use ArchTech\Enums\Options;
use Spatie\TypeScriptTransformer\Attributes\TypeScript;

#[TypeScript]
enum InvoiceType: string
{
    use Options;

    case Sale = 'sale';
    case Purchase = 'purchase';

    case RecurringSale = 'recurring-sale';
    case RecurringPurchase = 'recurring-purchase';

    public function isSale(): bool
    {
        return match ($this) {
            default => false,
            self::Sale, self::RecurringSale => true,
        };
    }

    public function isRecurring(): bool
    {
        return match ($this) {
            default => false,
            self::RecurringSale, self::RecurringPurchase => true,
        };
    }

    public function baseType(): self
    {
        return match ($this) {
            self::Sale, self::Purchase => $this,
            self::RecurringSale => self::Sale,
            self::RecurringPurchase => self::Purchase,
        };
    }

    /**
     * @return self[]
     */
    public static function onlyBase(): array
    {
        return [
            self::Sale,
            self::Purchase,
        ];
    }
}
