<?php

declare(strict_types=1);

namespace Bridge\Domains\Invoice\Enums;

use ArchTech\Enums\Options;
use Spatie\TypeScriptTransformer\Attributes\TypeScript;

#[TypeScript]
enum InvoiceStatus: string
{
    use Options;

    case Paid = 'paid';
    case Pending = 'pending';
    case Cancelled = 'cancelled';

    case RecurringEnded = 'recurring_ended';
    case RecurringActive = 'recurring_active';
    case RecurringCancelled = 'recurring_cancelled';

    public function isPaid(): bool
    {
        return $this === self::Paid;
    }

    public function isPending(): bool
    {
        return $this === self::Pending;
    }

    public function isCancelled(): bool
    {
        return $this === self::Cancelled;
    }

    /**
     * @return InvoiceStatus[]
     */
    public static function base(): array
    {
        return [
            self::Paid,
            self::Pending,
            self::Cancelled,
        ];
    }

    /**
     * @return InvoiceStatus[]
     */
    public static function recurring(): array
    {
        return [
            self::RecurringEnded,
            self::RecurringActive,
            self::RecurringCancelled,
        ];
    }
}
