<?php

declare(strict_types=1);

namespace Bridge\Domains\Bookkeeping\Enums;

use ArchTech\Enums\Options;
use Spatie\TypeScriptTransformer\Attributes\TypeScript;

#[TypeScript]
enum CompanyShareholder: string
{
    use Options;

    case TonmoyAjize = 'tonmoy_ajize';
    case IstiakTridip = 'istiak_tridip';

    public function percentage(): float
    {
        return match ($this) {
            self::TonmoyAjize => 0.62,
            self::IstiakTridip => 0.38,
        };
    }

    public function name(): string
    {
        return match ($this) {
            self::TonmoyAjize => 'Tonmoy Ajize',
            self::IstiakTridip => 'Istiak Tridip',
        };
    }
}
