<?php

declare(strict_types=1);

namespace Bridge\Database\Seeders;

use Bridge\Database\Seeders\Items\ProductSeeder;
use Bridge\Domains\Currency\Currency;
use Bridge\Domains\Item\Enums\ItemStatus;
use Bridge\Domains\Item\Enums\ItemType;
use Bridge\Domains\Item\Models\Item;
use Bridge\Domains\Supplier\Supplier;
use Illuminate\Database\Seeder;

class ItemSeeder extends Seeder
{
    public function run(): void
    {
        $supplierId = Supplier::query()->value('id');

        $this->seedServices($supplierId);
        $this->call(ProductSeeder::class);
    }

    private function seedServices(mixed $supplierId): void
    {
        $item = Item::query()->create([
            'name' => 'Script Installation',
            'supplier_id' => $supplierId,
            'type' => ItemType::Service,
            'status' => ItemStatus::Active,
        ]);

        $item->price()->create([
            'sell_for' => 50,
            'sell_currency_id' => Currency::defaultCurrency()->id,

            'buy_for' => 0,
            'buy_currency_id' => Currency::defaultCurrency()->id,
        ]);

        $item = Item::query()->create([
            'name' => 'Server Management',
            'supplier_id' => $supplierId,
            'type' => ItemType::Service,
            'status' => ItemStatus::Active,
        ]);

        $item->price()->create([
            'sell_for' => 200,
            'sell_currency_id' => Currency::defaultCurrency()->id,

            'buy_for' => 0,
            'buy_currency_id' => Currency::defaultCurrency()->id,
        ]);
    }
}
